<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_5c86c1795fe82',
	'title' => 'Front page slider',
	'fields' => array(
		array(
			'key' => 'field_543bebdeb29b9',
			'label' => 'Slider with captions',
			'name' => 'slider_with_captions',
			'type' => 'true_false',
			'instructions' => 'If this is ON, you will be able to define the caption, category, text and button for each slide. Otherwise only the images will be shown in the slider.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Use the captions with text over the slider',
			'default_value' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_543be9800cdbb',
			'label' => 'Slides',
			'name' => 'slides',
			'type' => 'repeater',
			'instructions' => 'You can add multiple slides to the front page, each with its own caption.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'row_min' => '',
			'row_limit' => '',
			'layout' => 'row',
			'button_label' => 'Add Another Slide',
			'min' => 0,
			'max' => 0,
			'collapsed' => '',
			'sub_fields' => array(
				array(
					'key' => 'field_543be9d60cdbc',
					'label' => 'Slide image',
					'name' => 'slide_image',
					'type' => 'image',
					'instructions' => 'The best image size for the slider is 1920 pixels wide and 580 pixels high (the same image dimensions are used in the theme demo). You can also upload images of different size but this might break the theme layout.',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'id',
					'preview_size' => 'jumbotron-slider-s',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_543beac80cdbe',
					'label' => 'Slide title',
					'name' => 'slide_title',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_543bebdeb29b9',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'formatting' => 'html',
					'maxlength' => '',
				),
				array(
					'key' => 'field_543bea2f0cdbd',
					'label' => 'Slide category',
					'name' => 'slide_category',
					'type' => 'text',
					'instructions' => 'This is shown above the slide title. Note: on some header styles, this field is not displayed (example: Transparent header).',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_543bebdeb29b9',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'Featured Projects',
					'prepend' => '',
					'append' => '',
					'formatting' => 'html',
					'maxlength' => '',
				),
				array(
					'key' => 'field_543beb42d353b',
					'label' => 'Slide text',
					'name' => 'slide_text',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_543bebdeb29b9',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'toolbar' => 'full',
					'media_upload' => 0,
					'tabs' => 'all',
					'delay' => 0,
				),
			),
		),
		array(
			'key' => 'field_543cf0cba7847',
			'label' => 'Auto cycle',
			'name' => 'auto_cycle',
			'type' => 'true_false',
			'instructions' => 'Automatically cycle over the slides on the page load.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Automatically cycle the slides',
			'default_value' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_543cf169a7848',
			'label' => 'Cycle interval',
			'name' => 'cycle_interval',
			'type' => 'number',
			'instructions' => 'Cycle interval in miliseconds (1s = 1000ms).',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_543cf0cba7847',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 5000,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'ms',
			'min' => 0,
			'max' => '',
			'step' => 1000,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-page-slider.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5c86c17975573',
	'title' => 'Full page background',
	'fields' => array(
		array(
			'key' => 'field_587f66113cf5e',
			'label' => 'Background type',
			'name' => 'bg_type',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'color' => 'Solid color',
				'image' => 'Image',
				'video' => 'Video',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'image',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_5878d46eff340',
			'label' => 'Background Image',
			'name' => 'bg_image',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'return_format' => 'url',
			'min_width' => 0,
			'min_height' => 0,
			'min_size' => 0,
			'max_width' => 0,
			'max_height' => 0,
			'max_size' => 0,
			'mime_types' => '',
		),
		array(
			'key' => 'field_587c93cbbf609',
			'label' => 'Background image horizontal position',
			'name' => 'bg_image_horizontal_position',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left' => 'Left',
				'center' => 'Center',
				'right' => 'Right',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'center',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_587c9405bf60a',
			'label' => 'Background image vertical position',
			'name' => 'bg_image_vertical_position',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'top' => 'Top',
				'center' => 'Center',
				'bottom' => 'Bottom',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'center',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_587c943fbf60b',
			'label' => 'Background image repeat',
			'name' => 'bg_image_repeat',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no-repeat' => 'No Repeat',
				'repeat' => 'Tile',
				'repeat-x' => 'Tile Horizontally',
				'repeat-y' => 'Tile Vertically',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'repeat',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_587c9472bf60c',
			'label' => 'Background image attachment',
			'name' => 'bg_image_attachment',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'scroll' => 'Scroll',
				'fixed' => 'Fixed',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'scroll',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_587f36bb8cee2',
			'label' => 'Background image size',
			'name' => 'bg_image_size',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'auto' => 'Auto',
				'contain' => 'Contain',
				'cover' => 'Cover',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'auto',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_587f6cb5d8928',
			'label' => 'Background video image placeholder',
			'name' => 'bg_video_image',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'video',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'return_format' => 'url',
			'min_width' => 0,
			'min_height' => 0,
			'min_size' => 0,
			'max_width' => 0,
			'max_height' => 0,
			'max_size' => 0,
			'mime_types' => '',
		),
		array(
			'key' => 'field_587f60eda9939',
			'label' => 'Background video (mp4 format)',
			'name' => 'bg_video_mp4',
			'type' => 'file',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'video',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'library' => 'all',
			'return_format' => 'url',
			'min_size' => 0,
			'max_size' => 0,
			'mime_types' => '',
		),
		array(
			'key' => 'field_587f6929c1717',
			'label' => 'Background video (webm format)',
			'name' => 'bg_video_webm',
			'type' => 'file',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '==',
						'value' => 'video',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'library' => 'all',
			'return_format' => 'url',
			'min_size' => 0,
			'max_size' => 0,
			'mime_types' => '',
		),
		array(
			'key' => 'field_587c9244c6c76',
			'label' => 'Background color',
			'name' => 'bg_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_587f66113cf5e',
						'operator' => '!=',
						'value' => 'video',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-empty.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5c86c1798d62b',
	'title' => 'Main title area background',
	'fields' => array(
		array(
			'key' => 'field_5885e420093c6',
			'label' => 'Show main title area',
			'name' => 'show_main_title_area',
			'type' => 'radio',
			'instructions' => 'Hiding title area will also hide breadcrumbs.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'yes' => 'Yes',
				'no' => 'No',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'yes',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_548ac758c8459',
			'label' => 'Background image',
			'name' => 'background_image',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'return_format' => 'url',
			'min_width' => 0,
			'min_height' => 0,
			'min_size' => 0,
			'max_width' => 0,
			'max_height' => 0,
			'max_size' => 0,
			'mime_types' => '',
		),
		array(
			'key' => 'field_548ac795c845a',
			'label' => 'Background image horizontal position',
			'name' => 'background_image_horizontal_position',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left' => 'Left',
				'center' => 'Center',
				'right' => 'Right',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'center',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_548ac96059261',
			'label' => 'Background image vertical position',
			'name' => 'background_image_vertical_position',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'top' => 'Top',
				'center' => 'Center',
				'bottom' => 'Bottom',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'center',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_548ac7f5c845b',
			'label' => 'Background image repeat',
			'name' => 'background_image_repeat',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no-repeat' => 'No Repeat',
				'repeat' => 'Tile',
				'repeat-x' => 'Tile Horizontally',
				'repeat-y' => 'Tile Vertically',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'repeat',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_548ac864c845c',
			'label' => 'Background image attachment',
			'name' => 'background_image_attachment',
			'type' => 'radio',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'scroll' => 'Scroll',
				'fixed' => 'Fixed',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'scroll',
			'layout' => 'vertical',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_548ac899c845d',
			'label' => 'Background color',
			'name' => 'background_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#f2f2f2',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'default',
			),
		),
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-builder-page.php',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'portfolio',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5c86c1799afe1',
	'title' => 'Page Slider',
	'fields' => array(
		array(
			'key' => 'field_5463508653f33',
			'label' => 'Slider Type',
			'name' => 'slider_type',
			'type' => 'radio',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'layer' => 'LayerSlider',
				'revolution' => 'Revolution Slider',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => '',
			'layout' => 'vertical',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_5463511b53f34',
			'label' => 'LayerSlider ID',
			'name' => 'layer_slider_id',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_546351d953f35',
			'label' => 'Revolution Slider Alias',
			'name' => 'revolution_slider_alias',
			'type' => 'text',
			'instructions' => '',
			'required' => false,
			'conditional_logic' => false,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			0 => false,
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'page_template',
				'operator' => '==',
				'value' => 'template-front-page-slider-alt.php',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5c86c179a6cf0',
	'title' => 'Position of the Sidebar',
	'fields' => array(
		array(
			'key' => 'field_543251af2850a',
			'label' => '',
			'name' => 'sidebar',
			'type' => 'radio',
			'instructions' => 'Position the sidebar for this particular page: left, right or do not display it at all.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'right' => 'Right',
				'left' => 'Left',
				'none' => 'No Sidebar',
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'right',
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-page-slider.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-front-page-slider-alt.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'template-empty.php',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5c86c179ab9eb',
	'title' => 'Project details and gallery',
	'fields' => array(
		array(
			'key' => 'field_544a786faaa9b',
			'label' => 'Construction date',
			'name' => 'construction_date',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'formatting' => 'html',
			'maxlength' => '',
		),
		array(
			'key' => 'field_544a798caaa9c',
			'label' => 'Location',
			'name' => 'location',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'formatting' => 'html',
			'maxlength' => '',
		),
		array(
			'key' => 'field_544a79caaaa9d',
			'label' => 'Surface area',
			'name' => 'surface_area',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'formatting' => 'html',
			'maxlength' => '',
		),
		array(
			'key' => 'field_544a7a1eaaa9e',
			'label' => 'Contracting investor',
			'name' => 'contracting_investor',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'formatting' => 'html',
			'maxlength' => '',
		),
		array(
			'key' => 'field_544a7a91aaa9f',
			'label' => 'Value',
			'name' => 'value',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'formatting' => 'html',
			'maxlength' => '',
		),
		array(
			'key' => 'field_547c9a1be0dd5',
			'label' => 'Category',
			'name' => 'category',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'Show categories',
			'default_value' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_546b42a17fec6',
			'label' => 'Additional Fields',
			'name' => 'additional_fields',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'row_min' => '',
			'row_limit' => '',
			'layout' => 'table',
			'button_label' => 'Add Field',
			'min' => 0,
			'max' => 0,
			'collapsed' => '',
			'sub_fields' => array(
				array(
					'key' => 'field_54747fc31dbb6',
					'label' => 'Icon',
					'name' => 'icon',
					'type' => 'text',
					'instructions' => '',
					'required' => false,
					'conditional_logic' => false,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					0 => false,
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_546b42ce7fec7',
					'label' => 'Name',
					'name' => 'name',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'formatting' => 'html',
					'maxlength' => '',
				),
				array(
					'key' => 'field_546b42fb7fec8',
					'label' => 'Value',
					'name' => 'value',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'formatting' => 'html',
					'maxlength' => '',
				),
			),
		),
		array(
			'key' => 'field_544a7adeaaaa0',
			'label' => 'Project gallery',
			'name' => 'project_gallery',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'row_min' => '',
			'row_limit' => '',
			'layout' => 'table',
			'button_label' => 'Add Image',
			'min' => 0,
			'max' => 0,
			'collapsed' => '',
			'sub_fields' => array(
				array(
					'key' => 'field_544a7b0daaaa1',
					'label' => 'Project image',
					'name' => 'project_image',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'preview_size' => 'thumbnail',
					'library' => 'all',
					'return_format' => 'id',
					'min_width' => 0,
					'min_height' => 0,
					'min_size' => 0,
					'max_width' => 0,
					'max_height' => 0,
					'max_size' => 0,
					'mime_types' => '',
				),
			),
		),
		array(
			'key' => 'field_583eb86ce88c2',
			'label' => 'Show gallery titles',
			'name' => 'show_gallery_titles',
			'type' => 'true_false',
			'instructions' => 'Title will be shown above the image',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_583eb94be88c3',
			'label' => 'Show gallery captions',
			'name' => 'show_gallery_captions',
			'type' => 'true_false',
			'instructions' => 'Caption will be shown below the image',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'portfolio',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
	),
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5c86c179c97d2',
	'title' => 'Subtitle',
	'fields' => array(
		array(
			'key' => 'field_55472b7e5eaf2',
			'label' => '',
			'name' => 'subtitle',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => 'Subtitle',
			'append' => '',
			'formatting' => 'html',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'seamless',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
	),
	'active' => true,
	'description' => '',
));

endif;
